package org.msh.tb.bd.tbforms.dhis2.schedule.scheduler;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.annotations.async.Expiration;
import org.jboss.seam.annotations.async.IntervalCron;
import org.jboss.seam.async.QuartzTriggerHandle;
import org.msh.tb.application.tasks.TaskManager;
import org.msh.tb.bd.tbforms.dhis2.schedule.asynctask.DHIS2ExportTB10ScheduleAsyncTask;
import org.msh.tb.bd.tbforms.dhis2.schedule.asynctask.DHIS2ExportTB12ScheduleAsyncTask;

import java.util.Date;

/**
 * Created by mauri on 07/07/2017.
 */
@AutoCreate
@Name("dHIS2TB12ExportationScheduler")
@Scope(ScopeType.APPLICATION)
public class DHIS2TB12ExportationScheduler extends DHIS2ExportationScheduler {

    @Override
    @Asynchronous
    @Transactional
    public QuartzTriggerHandle createQuartzTimer(
            @Expiration Date when, @IntervalCron String interval) {

        // start TB 12 exportation
        taskManager.runTask(DHIS2ExportTB12ScheduleAsyncTask.class, getParams());

        return null;
    }
}
